﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Persistance;
using Domaine;
using Test;

namespace IHM
{
    /// <summary>
    /// Fenêtre principale de l'IHM
    /// </summary>
    public partial class FrmPrincipale : Form
    {
        /// <summary>
        /// Objet d'accès aux données
        /// </summary>
        AccesDonnees accesDonnees;

        public FrmPrincipale()
        {
            InitializeComponent();

            gbContenu.Anchor = (AnchorStyles.None);
            btnQuitter.Anchor = (AnchorStyles.None);

            // instanciation de l'objet d'accès aux données
            // changer la classe instanciée pour utiliser les données de test
            // ou celles provenant de la BD
            accesDonnees = new AccesDonneesBD();

            try
            {
                AfficherContenu();
            }
            
            catch (Exception e)
            {
                MessageBox.Show(e.Message,"Erreur de base de données", MessageBoxButtons.OK, MessageBoxIcon.Error);
                Environment.Exit(0);
            }
        }

        /// <summary>
        /// Remplit les trois tableaux de l'IHM : utilisateurs, livres, emprunts
        /// </summary>
        private void AfficherContenu()
        {
            dgvUtils.Rows.Clear();  // suppression des éventuelles lignes existantes

            // Accès à la liste des utilisateurs et remplissage du tableau
            foreach (Utilisateur utilisateur in accesDonnees.GetUtilisateurs())
            {
                string[] ligne = { utilisateur.Id.ToString(), utilisateur.Nom, utilisateur.Prenom };
                dgvUtils.Rows.Add(ligne);
            }
            // tri sur la 1ère colonne (id)
            dgvUtils.Sort(dgvUtils.Columns[0], ListSortDirection.Ascending);

            dgvLivre.Rows.Clear();  // suppression des éventuelles lignes existantes
            dgvEmprunt.Rows.Clear();  // suppression des éventuelles lignes existantes


            // Accès à la liste des utilisateurs et remplissage du tableau
            foreach (Livre livre in accesDonnees.GetLivres())
            {
                string[] ligne = { livre.Isbn, livre.Titre, livre.Auteur };
                dgvLivre.Rows.Add(ligne);
            }

            // Accès à la liste emprunt et remplissage du tableau
            foreach (Emprunt emprunt in accesDonnees.GetEmprunts())
            {
                string[] ligne = { emprunt.Date.ToShortDateString(), emprunt.Emprunteur.Nom, emprunt.Livre.Titre, emprunt.Rendu.ToString() };
                dgvEmprunt.Rows.Add(ligne);
            }

        }

        private void btnQuitter_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void btnRetour_Click(object sender, EventArgs e)
        {
            DlgRetour dlgRetour = new DlgRetour(accesDonnees.GetEmpruntsNonRendus());
            if (dlgRetour.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    // le retour est validé
                    Emprunt emprunt = dlgRetour.GetEmpruntRendu();
                    emprunt.Rendu = true;

                    // sauvegarder la modification de l'emprunt
                    accesDonnees.EnregistrerRetour(emprunt);
                    MessageBox.Show("Retour enregistré","Enregistrement retour",MessageBoxButtons.OK, MessageBoxIcon.Information);
                }

                catch
                {
                    MessageBox.Show("Erreur : Il n'y a pas de livre à rendre", "Erreur retour", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }

                AfficherContenu();
            }
        }

        private void btnNouvelEmprunt_Click(object sender, EventArgs e)
        {
            DlgEmprunt dlgEmprunt = new DlgEmprunt(accesDonnees.GetUtilisateurs(), accesDonnees.GetLivresEmpruntables());
            if (dlgEmprunt.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    // l'emprunt est validé 
                    Utilisateur utilisateur = dlgEmprunt.GetUtils();
                    Livre livre = dlgEmprunt.GetLivre();
                    Emprunt emprunt = new Emprunt(utilisateur, livre);

                    // sauvegarder la modification de l'emprunt
                    accesDonnees.Ajouter(emprunt);
                    MessageBox.Show("Emprunt enregistré","Enregistrment emprunt", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    
                }

                catch
                {
                    MessageBox.Show("Erreur : L'emprunt n'a pût être effectué", "Erreur emprunt", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }

                AfficherContenu();
            }
        }

        private void btnEnregistrerUtilisateur_Click(object sender, EventArgs e)
        {
            DlgNvlUtilisateur dlgUtilisateur = new DlgNvlUtilisateur();
            if (dlgUtilisateur.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    Utilisateur utilisateur = new Utilisateur(dlgUtilisateur.GetNomUtil(),dlgUtilisateur.GetPrenomUtil());
                    accesDonnees.EnregistrerUtilisateur(utilisateur);
                    MessageBox.Show("Utilisateur enregistré","Enregistrement utilisateur",MessageBoxButtons.OK, MessageBoxIcon.Information);
                }

                catch (Exception ex)
                {
                    MessageBox.Show("Veuillez saisir toutes les informations " + ex.Message, "Erreur saisie", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }

                AfficherContenu();
            }
        }

        private void btnEnregistrerLivre_Click(object sender, EventArgs e)
        {
            DlgNvxLivre dlgLivre = new DlgNvxLivre();
            if (dlgLivre.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    Livre livre = new Livre(dlgLivre.GetISBNLivre(), dlgLivre.GetTitreLivre(), dlgLivre.GetAuteurLivre());
                    accesDonnees.EnregistrerLivre(livre);
                    MessageBox.Show("Livre enregistré", "Enregistrement livre", MessageBoxButtons.OK, MessageBoxIcon.Information);
                    
                }

                catch (Exception ex)
                {
                    MessageBox.Show("Veuillez saisir toutes les informations " + ex.Message, "Erreur saisie", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                }

                AfficherContenu();
            }
        } 
    }
}
